function [lmfreq,info] = locomax_freq(data,range)
%This function helps the user calculate the value that occur most
%frequently with the criteria set.  This is essentially the local max of a 
%vector.
%Synatax:   [lmfreq,info] = locomax_freq(data,range); 
%Input:     data = the input scalar data, the max frequency is calculated
%                  along columns, if there are multiple columns the max
%                  frequency of occurance will be calculated for all values
%                  of all columns
%           range = the number of uniqe bins that is lower in both
%                   directions of a value to define that value as a local
%                   max.  Default = 10;
%Output:    lmfreq = a 1 by x vector cell where each cell contain a column
%                   of local maxes sorted from smallest to largest values
%           info = a data structure holding pertinent info for the
%                   local maxs calculated.  Fields:
%                   lmax_num = The number of local maxes found
%                   data_bins = the bins created by the collapse.  It has
%                           both the value of each bin and the frequency of
%                           that value in the data set
%                   lmax_idx = the location of the local maxs in the
%                           bin array.
%                   lmax_values = the values of the local maxs,
%                           matches the structure of the lmfreq data array


%parse
if nargin==1
    range = 10;     %default
end

%preallocate
lmfreq = cell(1,size(data,2));
values = cell(1,size(data,2));
index_tmp = cell(1,size(data,2));
num_tmp = zeros(1,size(data,2));
for i = 1:size(data,2)      %step through columns
    col_tmp = data(:,i);    %pull one column to play with
    col_tmp = sort(col_tmp);    %sort the column first so all like values are bunched
    [col_idx,noidx,bins] = collapse(col_tmp,1);  %collapse down the column into an index of the values in the column
    info(1).data_bins = bins;       %store the bins value and frequency
    bins = bins(2,:);         %pass on only the frequency for now.
    %now roll through the bins to find local maxes
    curr_max = bins(1);       %initiate the temporary max holder, give it the first data point
    curr_max_idx = 1;         %initiate the local max index holder
    count = range+1;          %initiate the count down variable, +1 just how indexing actually works
    local_max_num = 0;        %initiate the local max counter
    locomax_idx = [];         %initiate
    for j = 2:size(bins,2)
        if bins(j)>=curr_max     %higher, you are now the new king of the hill
            curr_max = bins(j);
            curr_max_idx = j;
            count = range+1;
        else    %not higher, the count down beings
            count = count-1;
        end
        if j==size(bins,2)      %at the end
            count = 0;      %check the last held point
        end
        if count==0     %Are you the king of your little hill
            if local_max_num>=1      %not first time through
                if max(bins(j-range:j))<=curr_max    %you are the king
                    local_max_num = local_max_num+1;
                    locomax_idx(local_max_num) = curr_max_idx;
                end
                curr_max = bins(j);   %the next value is the new king contender
            else
                local_max_num = local_max_num+1;
                locomax_idx(local_max_num) = curr_max_idx;
                curr_max = bins(j);   %the next value is the new king contender
            end
            count = range+2;          %reset count +2, because the next next comparision is a no brainer
        end
    end
    %the location of the max bin is the location of the max value in col_idx
    lmfreq{i} = col_idx(locomax_idx);            %set the value
    index_tmp{i} = locomax_idx';                 %store the index values
    num_tmp(i) = local_max_num;                  %store the number of local maxes
end
%create output info structure
info(1).lmax_values = values;
info(1).lmax_idx = index_tmp;
info(1).lmax_num = local_max_num;